
#ifndef CMRCONTROLLERIMPL_H
#define CMRCONTROLLERIMPL_H

#include <string>
#include "services/impl/base/CMRControllerBaseImpl.h"
#include "CMRControllerDef.h"

namespace CSFUnified
{	
	class CSFUNIFIED_API CMRControllerImpl : public CMRControllerBaseImpl
    {
	public:
		CMRControllerImpl(SMART_PTR_NS::shared_ptr<UnifiedFactory> unifiedFactory, const std::string JID);
		virtual ~CMRControllerImpl();
		
		virtual std::string getJID();
		virtual std::string getsipUrl();
		virtual std::string gethostPin();
		virtual std::string getguestPin();
		virtual std::string getjoinUrl();
		virtual std::string getjoinParam();
		virtual void start(bool isAutoStartMeeting);
        virtual void join(std::string joinParam);

		void clearCMRProperty();
		void setCMRProperty(CMRProperty& property);
        bool onCmrMeetingStarted(const CMRMeetingData& info);
        bool onCmrMeetingJoined();
        bool onCmrMeetingEnded();
        bool onCmrMeetingError(bool& isHost);

		static bool isInvalidPMR(CMRProperty& property);

	private:
        void clearCMRParam();
		void updatePMRParam();
		void updateCMRParam(const CMRMeetingData& meetingInfo);
		std::string encodeJoinParam(const std::string siteUrl, const std::string siteName, const std::string meetingKey, const std::string mkgtk);
		void decodeJoinParam(std::string joinParam, std::string& siteUrl, std::string& siteName, std::string& meetingKey, std::string& mkgtk);
		void setValueToJoinParam(std::string& joinParam, std::string tag, std::string value);
		std::string getValueFromJoinParam(std::string joinParam, std::string tag);

	private:
		std::string m_JID;
		std::string m_sipUrl;
		std::string m_hostPin;
		std::string m_guestPin;
		std::string m_joinUrl;
		std::string m_joinParam;

		bool m_isHost;
		bool m_isCMRInProgress;
		bool m_isWebExInLaunching;
		bool m_isWebExLaunched;
		bool m_isGroupChatExist;
		bool m_isNeedDelete;
		CMRProperty m_property;
	};
    
}

#endif